/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;

public class VWCommandLineArgs {
    private Properties properties = new Properties();
    private char[] paramValueDelimiters = new char[]{'=', ':'};
    private char[] paramBeginChars = new char[]{'/', '-'};
    private boolean ignoreCase = false;

    public VWCommandLineArgs(Properties props) {
        if (props != null) {
            this.properties = props;
        }
    }

    public VWCommandLineArgs(String[] argv) {
        this.parseArgs(argv);
        try {
            String filename = this.getParameter("inputfile");
            if (filename != null && filename.length() > 0) {
                this.readFileArgs(filename);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public VWCommandLineArgs(String[] argv, boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        this.parseArgs(argv);
    }

    public VWCommandLineArgs(String[] argv, boolean ignoreCase, char[] paramBeginChars) {
        this.ignoreCase = ignoreCase;
        this.paramBeginChars = paramBeginChars;
        this.parseArgs(argv);
    }

    public VWCommandLineArgs(String fileName, boolean ignoreCase) throws Exception {
        this.ignoreCase = ignoreCase;
        this.readFileArgs(fileName);
    }

    private void readFileArgs(String fileName) throws Exception {
        InputStream inStream = null;
        try {
            inStream = new BufferedInputStream(new FileInputStream(fileName));
            this.properties.load(inStream);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public VWCommandLineArgs(String[] argv, String[] argNames, boolean ignoreCase) {
        if (argv == null || argNames == null) {
            return;
        }
        this.ignoreCase = ignoreCase;
        int nArgNames = argNames.length;
        int nArgv = argv.length;
        if (nArgNames < nArgv) {
            // empty if block
        }
        for (int i = 0; i < nArgv && i <= nArgNames; ++i) {
            String name = argNames[i];
            if (this.ignoreCase) {
                name = name.toUpperCase(Locale.ENGLISH);
            }
            this.properties.setProperty(name, argv[i]);
        }
    }

    public void setParamValueDelimiters(char[] s) {
        if (s != null) {
            this.paramValueDelimiters = s;
        }
    }

    public void setParamBeginChars(char[] s) {
        if (s != null) {
            this.paramBeginChars = s;
        }
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public String getParameter(String paramName) {
        if (this.ignoreCase) {
            paramName = paramName.toUpperCase(Locale.ENGLISH);
        }
        return this.properties.getProperty(paramName);
    }

    public String getParameter(String paramName, String defaultValue) {
        if (this.ignoreCase) {
            paramName = paramName.toUpperCase(Locale.ENGLISH);
        }
        return this.properties.getProperty(paramName, defaultValue);
    }

    public int getIntParameter(String paramName, int defaultValue) {
        String value;
        if (this.ignoreCase) {
            paramName = paramName.toUpperCase(Locale.ENGLISH);
        }
        if ((value = this.properties.getProperty(paramName)) == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public boolean isPresent(String flag) {
        if (this.ignoreCase) {
            flag = flag.toUpperCase(Locale.ENGLISH);
        }
        return null != this.properties.getProperty(flag);
    }

    public void list(PrintStream out) {
        this.properties.list(out);
    }

    public void list(PrintWriter out) {
        this.properties.list(out);
    }

    public void load(InputStream inStream) throws IOException {
        this.properties.load(inStream);
    }

    public Enumeration parameterNames() {
        return this.properties.propertyNames();
    }

    public static void main(String[] argv) {
        String theRouterName = null;
        String theServerURL = null;
        String userName = null;
        String password = null;
        int aRouterPort = 0;
        int aPPMPort = 0;
        int isolatedRegion = 0;
        int connectRetry = 0;
        int multirmiconnects = 0;
        int debugOn = 0;
        String aVWJSName = null;
        int aVWJSPort = 0;
        boolean register = true;
        String UNBIND = "unbind";
        String HELP = "?";
        String NAMED_PARAMS = "namedParams";
        String ROUTER_NAME = "routerName";
        String SERVER_URL = "serverURL";
        String USER = "user";
        String PW = "pw";
        String IR = "ir";
        String ROUTER_PORT = "routerPort";
        String PPM_PORT = "ppmPort";
        String MULTI_RMI = "multiRMI";
        String DEBUG_LEVEL = "debugLevel";
        String CONNECT_RETRY = "connectRetry";
        String VWJS_NAME = "VWJSName";
        String VWJS_PORT = "VWJSPort";
        String[] argNames = new String[]{"routerName", "serverURL", "user", "pw", "ir", "routerPort", "ppmPort", "multiRMI", "debugLevel", "connectRetry", "VWJSName", "VWJSPort"};
        VWCommandLineArgs c = new VWCommandLineArgs(argv, true);
        if (argv.length == 0) {
            System.out.println("Getting dialog here.");
        } else {
            if (c.isPresent("unbind")) {
                System.out.println("want to unbind?");
                System.exit(1);
            }
            if (c.isPresent("?")) {
                System.out.println("Want help information?");
                System.exit(1);
            }
            if (!c.isPresent("namedParams")) {
                c = new VWCommandLineArgs(argv, argNames, true);
            }
        }
        theRouterName = c.getParameter("routerName", "vwrouter");
        theServerURL = c.getParameter("serverURL", "localhost");
        userName = c.getParameter("user", "PEAdmin");
        password = c.getParameter("pw", "trident");
        aRouterPort = c.getIntParameter("routerPort", 32771);
        aPPMPort = c.getIntParameter("ppmPort", 32771);
        isolatedRegion = c.getIntParameter("ir", 1);
        connectRetry = c.getIntParameter("connectRetry", 0);
        multirmiconnects = c.getIntParameter("multiRMI", 0);
        debugOn = c.getIntParameter("debugLevel", 0);
        aVWJSName = c.getParameter("VWJSName");
        aVWJSPort = c.getIntParameter("VWJSPort", 0);
        System.out.println("routerName=" + theRouterName);
        System.out.println("serverURL=" + theServerURL);
        System.out.println("user=" + userName);
        System.out.println("pw=" + password);
        System.out.println("routerPort=" + aRouterPort);
        System.out.println("ppmPort=" + aPPMPort);
        System.out.println("ir=" + isolatedRegion);
        System.out.println("connectRetry=" + connectRetry);
        System.out.println("multiRMI=" + multirmiconnects);
        System.out.println("debugLevel=" + debugOn);
        System.out.println("VWJSName=" + aVWJSName);
        System.out.println("VWJSPort=" + aVWJSPort);
    }

    private boolean isAParam(String s) {
        boolean foundIt = false;
        if (s != null && s.length() > 0) {
            for (int j = 0; j < this.paramBeginChars.length && !foundIt; ++j) {
                foundIt = s.charAt(0) == this.paramBeginChars[j];
            }
        }
        return foundIt;
    }

    private void parseArgs(String[] argv) {
        for (int i = 0; i < argv.length; ++i) {
            int k = 0;
            int x = 0;
            String name = null;
            String value = null;
            if (this.isAParam(argv[i])) {
                k = 1;
                boolean foundIt = false;
                for (int j = 0; j < this.paramValueDelimiters.length && !foundIt; ++j) {
                    x = argv[i].indexOf(this.paramValueDelimiters[j], k);
                    foundIt = x > -1;
                }
                if (!foundIt) {
                    name = argv[i].substring(k);
                    if (++i < argv.length) {
                        if (this.isAParam(argv[i])) {
                            --i;
                        } else {
                            value = argv[i];
                        }
                    }
                } else {
                    name = argv[i].substring(k, x);
                    value = argv[i].substring(x + 1);
                }
                if (null == value) {
                    value = "";
                }
                if (this.ignoreCase) {
                    name = name.toUpperCase(Locale.ENGLISH);
                }
                this.properties.setProperty(name, value);
                continue;
            }
            name = argv[i];
            if (this.ignoreCase) {
                name = name.toUpperCase(Locale.ENGLISH);
            }
            this.properties.setProperty(name, "");
        }
    }

    public boolean help() {
        return this.isPresent("h") || this.isPresent("H") || this.isPresent("?") || this.isPresent("HELP");
    }
}

